#include <stdlib.h>
#include <string.h>

#include "kmodule_list.h"
#include "kmodule.h"

typedef struct kmodule_list_entry_t
{
	kmodule_t *kmodule;

	kmodule_list_entry_t *previous_entry;

	kmodule_list_entry_t *next_entry;
} kmodule_list_entry_t;


kmodule_list_t *kmodule_list_create(void)
{
	kmodule_list_entry_t *list_head;
	list_head=malloc(sizeof(kmodule_list_entry_t));

	if (list_head!=NULL)
	{
		list_head->kmodule=NULL;
		list_head->previous_entry=NULL;
		list_head->next_entry=NULL;
	}

	return (kmodule_list_t *)list_head;
}

void kmodule_list_free(kmodule_list_t *list)
{
	kmodule_list_entry_t *entry;
	kmodule_list_entry_t *next_entry;

	entry=(kmodule_list_entry_t *)list;

	while(entry!=NULL)
	{
		next_entry=entry->next_entry;
		free(entry);
		entry=next_entry;
	}
}

bool kmodule_list_is_empty(kmodule_list_t *list)
{
	return ((kmodule_list_entry_t *)list)->next_entry==NULL;
}


error_code_t kmodule_list_queue_module(kmodule_list_t *list, kmodule_t *kmodule, 
		kmodule_list_entry_t **list_entry_ptr)
{
	kmodule_list_entry_t *new_entry;
	kmodule_list_entry_t *head;
	kmodule_list_entry_t *first_entry;

	new_entry=malloc(sizeof(kmodule_list_entry_t));
	if (new_entry==NULL)
		return RESULT_NORESOURCES;

	//entry entry pntr
	new_entry->kmodule=kmodule;
	if (list_entry_ptr!=NULL)
		(*list_entry_ptr)=new_entry;

	//put in the new device between head and the first device
	head = (kmodule_list_entry_t*)list;
	first_entry=head->next_entry;

	//update forward links
	head->next_entry=new_entry;
	new_entry->next_entry=first_entry;

	//update backwards links
	new_entry->previous_entry=head;
	if (first_entry!=NULL)
		first_entry->previous_entry=new_entry;

	return RESULT_OK;
}

kmodule_t *kmodule_list_dequeue_module(kmodule_list_t *list)
{
	kmodule_t *kmodule;
	kmodule_list_entry_t *head;
	kmodule_list_entry_t *entry_to_dequeue;

	head=(kmodule_list_entry_t *)list;
	entry_to_dequeue=head->next_entry;

	if (entry_to_dequeue==NULL)
		return NULL;

	kmodule=entry_to_dequeue->kmodule;

	kmodule_list_remove_from_list(entry_to_dequeue);

	return kmodule;
}

kmodule_t *kmodule_list_first_entry(kmodule_list_t *list, kmodule_list_iterator_t *itr)
{
	if (itr!=NULL)
		(*itr)=(kmodule_list_iterator_t)((kmodule_list_entry_t *)list)->next_entry;
	return ((kmodule_list_entry_t *)list)->next_entry->kmodule;
}

kmodule_t  *kmodule_list_next_entry(kmodule_list_iterator_t *itr)
{
	kmodule_list_entry_t *cur_entry;
	cur_entry=(kmodule_list_entry_t *)(*itr);

	if (cur_entry!=NULL)
	{
		(*itr)=(kmodule_list_iterator_t)cur_entry->next_entry;
		if (cur_entry->next_entry!=NULL)
			return cur_entry->next_entry->kmodule;
	}

	return NULL;
}

void kmodule_list_remove_from_list(kmodule_list_entry_t *list_entry_ptr)
{
	kmodule_list_entry_t *entry_before_entry, *entry_after_entry;

	entry_before_entry=list_entry_ptr->previous_entry;
	entry_after_entry=list_entry_ptr->next_entry;

	//update the forward link
	entry_before_entry->next_entry=entry_after_entry;

	//update the backward link
	if (entry_after_entry!=NULL)
		entry_after_entry->previous_entry=entry_before_entry;

	//delete the entry
	free(list_entry_ptr);
}

kmodule_t *kmodule_list_get_entry(kmodule_list_t *list, const struct kmod_module *kmod)
{
	const char* m_name=kmod_module_get_name(kmod);
	kmodule_t *list_entry;
	kmodule_list_iterator_t list_itr;

	list_entry=kmodule_list_first_entry(list, &list_itr);
	while (list_entry!=NULL)
	{
		if (strcmp(kmodule_get_name(list_entry),m_name)==0)
			return list_entry;

		list_entry=kmodule_list_next_entry(&list_itr);
	}

	return NULL;
}
